﻿Imports System.Math

Module Module_MatrixFunctions

    ' -----------------------------------------------------------------------
    '  Add two matrices, their dimensions should be compatible
    ' -----------------------------------------------------------------------
    Public Function Add(ByVal Mat1(,) As Double, ByVal Mat2(,) As Double) As Double(,)
        Dim Rows1 As Int32 = Mat1.GetUpperBound(0)
        Dim Cols1 As Int32 = Mat1.GetUpperBound(1)
        Dim Rows2 As Int32 = Mat2.GetUpperBound(0)
        Dim Cols2 As Int32 = Mat2.GetUpperBound(1)
        If Rows1 <> Rows2 Or Cols1 <> Cols2 Then
            Throw New Exception("Dimensions of the two matrices do not match.")
        End If
        Dim i, j As Integer
        Dim sol(Rows1, Cols1) As Double
        For i = 0 To Rows1
            For j = 0 To Cols1
                sol(i, j) = Mat1(i, j) + Mat2(i, j)
            Next
        Next
        Return sol
    End Function

    ' -----------------------------------------------------------------
    '  Subtracts two matrices. Dimensions should be compatible.
    ' -----------------------------------------------------------------
    Public Function Subtract(ByVal Mat1(,) As Double, ByVal Mat2(,) As Double) As Double(,)
        Dim Rows1 As Int32 = Mat1.GetUpperBound(0)
        Dim Cols1 As Int32 = Mat1.GetUpperBound(1)
        Dim Rows2 As Int32 = Mat2.GetUpperBound(0)
        Dim Cols2 As Int32 = Mat2.GetUpperBound(1)
        If Rows1 <> Rows2 Or Cols1 <> Cols2 Then
            Throw New Exception("Dimensions of the two matrices do not match.")
        End If
        Dim i, j As Integer
        Dim sol(Rows1, Cols1) As Double
        For i = 0 To Rows1
            For j = 0 To Cols1
                sol(i, j) = Mat1(i, j) - Mat2(i, j)
            Next
        Next
        Return sol
    End Function

    ' -----------------------------------------------------------------
    '  Multiply two matrices. Dimensions should be compatible.
    ' -----------------------------------------------------------------
    Public Function Multiply(ByVal Mat1(,) As Double, ByVal Mat2(,) As Double) As Double(,)
        Dim Rows1 As Int32 = Mat1.GetUpperBound(0)
        Dim Cols1 As Int32 = Mat1.GetUpperBound(1)
        Dim Rows2 As Int32 = Mat2.GetUpperBound(0)
        Dim Cols2 As Int32 = Mat2.GetUpperBound(1)
        If Rows1 <> Rows2 Or Cols1 <> Cols2 Then
            Throw New Exception("Dimensions of the two matrices do not match.")
        End If
        Dim l, i, j As Integer
        Dim sol(Rows1, Cols1) As Double
        Dim MulAdd As Double = 0
        For i = 0 To Rows1
            For j = 0 To Cols2
                For l = 0 To Cols1
                    MulAdd = MulAdd + Mat1(i, l) * Mat2(l, j)
                Next
                sol(i, j) = MulAdd
                MulAdd = 0
            Next
        Next
        Return sol
    End Function

    ' -----------------------------------------------------------------
    '  Determinant of a matrix. Should be (n x n)
    ' -----------------------------------------------------------------
    Public Function Determinant(ByVal Mat(,) As Double) As Double
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        If Rows <> Cols Then
            Throw New Exception("Matrix should be a square matrix.")
        End If
        Dim k, k1, i, j As Int32
        Dim save As Double
        Dim ArrayK As Double
        Dim Det As Double = 1
        Dim DArray(,) As Double = CType(Mat.Clone(), Double(,))
        For k = 0 To Rows
            If DArray(k, k) = 0 Then
                j = k
                Do While ((j < Rows) And (DArray(k, j) = 0))
                    j = j + 1
                Loop
                If DArray(k, j) = 0 Then
                    Det = 0
                    Exit Function
                Else
                    For i = k To Rows
                        save = DArray(i, j)
                        DArray(i, j) = DArray(i, k)
                        DArray(i, k) = save
                    Next
                End If
                Det = -Det
            End If
            ArrayK = DArray(k, k)
            Det = Det * ArrayK
            If k < Rows Then
                k1 = k + 1
                For i = k1 To Rows
                    For j = k1 To Rows
                        DArray(i, j) = DArray(i, j) - DArray(i, k) * (DArray(k, j) / ArrayK)
                    Next
                Next
            End If
        Next
        Return Det
    End Function

    ' -------------------------------------------------------------------
    '  Invert a matrix. Mat should be (N x N) and Determinant(Mat) <> 0
    ' -------------------------------------------------------------------
    Public Function Invert(ByVal Mat(,) As Double) As Double(,)
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        If Rows <> Cols Then
            Throw New Exception("Matrix should be a square matrix.")
        End If
        If Determinant(Mat) = 0 Then
            Throw New Exception("Determinent equals zero, inverse can't be found.")
        End If
        Dim AIN, AF As Double
        Dim LL, LLM, L1, L2, LC, LCA, LCB As Int32
        LL = Rows
        LLM = Cols
        Dim AI(LL, LL) As Double
        Dim Mat1(,) As Double = CType(Mat.Clone(), Double(,))
        For L2 = 0 To LL
            For L1 = 0 To LL
                AI(L1, L2) = 0
            Next
            AI(L2, L2) = 1
        Next
        For LC = 0 To LL
            If Abs(Mat1(LC, LC)) < 0.0000000001 Then
                For LCA = LC + 1 To LL
                    If LCA = LC Then Continue For
                    If Abs(Mat1(LC, LCA)) > 0.0000000001 Then
                        For LCB = 0 To LL
                            Mat1(LCB, LC) = Mat1(LCB, LC) + Mat1(LCB, LCA)
                            AI(LCB, LC) = AI(LCB, LC) + AI(LCB, LCA)
                        Next
                        Exit For
                    End If
                Next
            End If
            AIN = 1 / Mat1(LC, LC)
            For LCA = 0 To LL
                Mat1(LCA, LC) = AIN * Mat1(LCA, LC)
                AI(LCA, LC) = AIN * AI(LCA, LC)
            Next
            For LCA = 0 To LL
                If LCA = LC Then Continue For
                AF = Mat1(LC, LCA)
                For LCB = 0 To LL
                    Mat1(LCB, LCA) = Mat1(LCB, LCA) - AF * Mat1(LCB, LC)
                    AI(LCB, LCA) = AI(LCB, LCA) - AF * AI(LCB, LC)
                Next
            Next
        Next
        Return AI
    End Function

    ' -----------------------------------------------------------------
    '  Multiply two vectors, dimensions should be (3x1)
    ' -----------------------------------------------------------------
    Public Function MultiplyVectors(ByVal Mat1(,) As Double, ByVal Mat2(,) As Double) As Double(,)
        Dim Rows1 As Int32 = Mat1.GetUpperBound(0)
        Dim Cols1 As Int32 = Mat1.GetUpperBound(1)
        Dim Rows2 As Int32 = Mat2.GetUpperBound(0)
        Dim Cols2 As Int32 = Mat2.GetUpperBound(1)
        If Rows1 <> 2 Or Cols1 <> 0 Or Rows2 <> 2 Or Cols2 <> 0 Then
            Throw New Exception("Dimension should be (2 x 0) for both matrices in order to do cross multiplication.")
        End If
        Dim i, j, k As Double
        Dim sol(2, 0) As Double
        i = Mat1(1, 0) * Mat2(2, 0) - Mat1(2, 0) * Mat2(1, 0)
        j = Mat1(2, 0) * Mat2(0, 0) - Mat1(0, 0) * Mat2(2, 0)
        k = Mat1(0, 0) * Mat2(1, 0) - Mat1(1, 0) * Mat2(0, 0)
        sol(0, 0) = i
        sol(1, 0) = j
        sol(2, 0) = k
        Return sol
    End Function

    ' -----------------------------------------------------------------
    '  Magnitude of a Vector, vector should be (3x1)
    ' -----------------------------------------------------------------
    Public Function VectorMagnitude(ByVal Mat(,) As Double) As Double
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        If Rows <> 2 Or Cols <> 0 Then
            Throw New Exception("Dimension of the matrix should be (2 x 0) in order to find the vector's norm.")
        End If
        Return Sqrt(Mat(0, 0) * Mat(0, 0) + Mat(1, 0) * Mat(1, 0) + Mat(2, 0) * Mat(2, 0))
    End Function

    ' -----------------------------------------------------------------
    '  Matrix Transpose
    ' -----------------------------------------------------------------
    Public Function Transpose(ByVal Mat(,) As Double) As Double(,)
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        Dim i, j As Int32
        Dim Tr_Mat(Cols, Rows) As Double
        For i = 0 To Cols
            For j = 0 To Rows
                Tr_Mat(j, i) = Mat(i, j)
            Next
        Next
        Return Tr_Mat
    End Function

    ' -----------------------------------------------------------------
    '  Multiply a matrix or a vector with a scalar quantity
    ' -----------------------------------------------------------------
    Public Function ScalarMultiply(ByVal Value As Double, ByVal Mat(,) As Double) As Double(,)
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        Dim i, j As Int32
        Dim sol(Rows, Cols) As Double
        For i = 0 To Rows
            For j = 0 To Cols
                sol(i, j) = Mat(i, j) * Value
            Next
        Next
        Return (sol)
    End Function

    ' -----------------------------------------------------------------
    '  Divide matrix elements or a vector by a scalar quantity
    ' -----------------------------------------------------------------
    Public Function ScalarDivide(ByVal Value As Double, ByVal Mat(,) As Double) As Double(,)
        Dim Rows As Int32 = Mat.GetUpperBound(0)
        Dim Cols As Int32 = Mat.GetUpperBound(1)
        Dim i, j As Int32
        Dim sol(Rows, Cols) As Double
        For i = 0 To Rows
            For j = 0 To Cols
                sol(i, j) = Mat(i, j) / Value
            Next
        Next
        Return sol
    End Function

    ' -----------------------------------------------------------------
    '  Print a matrix to multitext text box
    ' -----------------------------------------------------------------
    Public Function PrintMat(ByVal Mat(,) As Double) As String
        Dim k, i, j, m As Integer
        Dim StrElem As String
        Dim StrLen As Int32
        Dim Greatest() As Integer
        Dim LarString As String = ""
        Dim OptiString, sol As String
        Dim N_Rows As Int32 = Mat.GetUpperBound(0)
        Dim N_Columns As Int32 = Mat.GetUpperBound(1)
        ReDim Greatest(N_Columns)
        sol = ""
        OptiString = ""
        For i = 0 To N_Rows
            For j = 0 To N_Columns
                If i = 0 Then
                    Greatest(j) = 0
                    For m = 0 To N_Rows
                        StrElem = Format$(Mat(m, j), "0.0000")
                        StrLen = Len(StrElem)
                        If Greatest(j) < StrLen Then
                            Greatest(j) = StrLen
                            LarString = StrElem
                        End If
                    Next m
                    If Mid$(LarString, 1, 1) = "-" Then Greatest(j) = Greatest(j) + 1
                End If
                StrElem = Format$(Mat(i, j), "0.0000")
                If Mid$(StrElem, 1, 1) = "-" Then
                    StrLen = Len(StrElem)
                    If Greatest(j) >= StrLen Then
                        For k = 1 To (Greatest(j) - StrLen)
                            OptiString = OptiString & "  "
                        Next k
                        OptiString = OptiString & " "
                    End If
                Else
                    StrLen = Len(StrElem)
                    If Greatest(j) > StrLen Then
                        For k = 1 To (Greatest(j) - StrLen)
                            OptiString = OptiString & "  "
                        Next k
                    End If
                End If
                OptiString = OptiString & "  " & Format$(Mat(i, j), "0.0000")
            Next j
            If i <> N_Rows Then
                sol = sol & OptiString & vbCrLf
                OptiString = ""
            End If
            sol = sol & OptiString
            OptiString = ""
        Next i
        Return sol
    End Function

End Module
